var debug_flg=false;
chrome.sockets.udp.onReceive.addListener(onReceiveUDP);
chrome.sockets.udp.onReceiveError.addListener(errorSocket);
chrome.sockets.tcp.onReceive.addListener(onReceive);
chrome.sockets.tcp.onReceiveError.addListener(errorSocket);
var GAIBU_FLG=true;
var RAKUTEN_FLG=true;

var imgcnt=0;
var WEBIP="10.20.100.200";
var PRICE_PORT = 10001;

var WEBIP="10.10.100.161";

var RING_MAX=5;

var init_flg=0;

//画像取得タイマーの停止対策
var lastTimer=(new Date()).getTime();
var TimerTimeout=5000;		//TimerTimeout秒以上呼ばれないときは再度呼び出す

var IMG_URL=new Array();
IMG_URL[0]="";
IMG_URL[1]="";
function setInitialUrl(){
	IMG_URL[0]="http://"+WEBIP+"/mainbuyer.php?spno=##SPNO##";
	IMG_URL[1]="http://"+WEBIP+"/buyer.php?spno=##SPNO##";
}

setInitialUrl();

var FILL_ZERO=0;
var FILL_SPACE=1;
var SPNO_LENGTH=5;
var SPNO_FILL=FILL_SPACE;

var sock_price=-1;

var LoadCallback=null;
var font_l=new Array();
var font_lane=new Array();
var noimage=new Image();
noimage.src="./img/noimage.png";

var lamp_start=new Image();
var lamp_urikiri=new Image();
var lamp_nagare=new Image();
var lamp_kettei=new Image();
var lamp_gaibu=new Image();
var lamp_teisei=new Image();
var cur_lamp=new Array();

var posLANE=new VectorClass();
var posSPNO=new VectorClass();
var posPRICE=new VectorClass();
var posANDON=new VectorClass();
var posSTART=new VectorClass();
var posURIKIRI=new VectorClass();
var posKETTEI=new VectorClass();
var posNAGARE=new VectorClass();
var posTEISEI=new VectorClass();
var posIMAGE=new VectorClass();

var main;
var main_canvas;
var main_context;
var main_canvas2;
var main_context2;

window.onload = function(){
	loadLargeFont();

	LoadConfig(null);
	initLane();
	window.onresize = window_resize();
	showModal(true,"起動処理中");
	openPrice();
};

function VectorClass(){
	//対象の位置・大きさ
	this.top=0;
	this.left=0;
	this.width=0;
	this.height=0;
	//各要素毎の幅・高さ
	this.w;
	this.h;
}

function LaneClass(){
	this.spno=-1;
	this.price=0;
	this.andon=0;
	this.lamp_start=0;
	this.lamp_urikiri=0;
	this.lamp_teisei=0;
	this.lamp_nagare=0;
	this.lamp_kettei=0;
	this.lamp_gaibu=0;
	this.ousatu_kbn=0;
	this.last_p1=null;
	this.last_p2=null;
	this.raku_seat;
	this.rakuten;
}

var MODE_NONE=0;
var MODE_LOADING=1;
var MODE_COMPLETE=2;
function ImageClass(){
	this.spno=-1;
	this.lane=-1;
	this.mode=0;
	this.img=new Image();
	this.loader=null;
	this.img.spno=-1;
	this.img.lane=-1;
}

//レーンセリ情報クラス
var lane_stat=new Array();
var lane_stat_new=new Array();

function initLane(){
	for(var i=0;i<6;i++){
		lane_stat[i]=new LaneClass();
		lane_stat_new[i]=new LaneClass();
		lane_stat[i].spno=-2;
		lane_stat[i].price=-2;
		lane_stat[i].andon=8;
		lane_stat[i].lamp_start=-3;
		lane_stat[i].lamp_urikiri=-1;
		lane_stat[i].lamp_teisei=-1;
		lane_stat[i].lamp_nagare=-1;
		lane_stat[i].lamp_kettei=-1;
		lane_stat[i].lamp_gaibu=-1;

		lane_stat_new[i].spno=0;
		lane_stat_new[i].price=0;
		lane_stat_new[i].andon=0;
		lane_stat_new[i].lamp_start=0;
		lane_stat_new[i].lamp_urikiri=0;
		lane_stat_new[i].lamp_teisei=0;
		lane_stat_new[i].lamp_nagare=0;
		lane_stat_new[i].lamp_kettei=0;
		lane_stat_new[i].lamp_gaibu=0;
	}
}


//画像バッファ作成 現出品０　次出品１
var imgArray=new Array();
for(var i=0;i<6;i++){
	imgArray[i]=new Array();
	for(var j=0;j<RING_MAX;j++){
		imgArray[i][j]=new ImageClass();
		imgArray[i][j].lane=i;
	}
}

//	allSocketClose();
//	if(sock_kanri!=-1){
//		chrome.sockets.tcp.close(sock_kanri);
//		sock_kanri=-1;
//	}

window.onhelp=function(){
	return false;
};

document.onkeydown=keydown;
function keydown(e){
	// InternetExplorer 用
	if (!e) e = window.event;
	console.log("key",e.keyCode.toString(16));

	if(isA(e.keyCode)){
		return false;
	}else if(isB(e.keyCode)){
		return false;
	}else if(isC(e.keyCode)){
		return false;
	}else if(isD(e.keyCode)){
		return false;
	}
	if(e.keyCode>=0x60 && e.keyCode<=0x69){
		//テンキーの処理
		var elm=document.getElementById("NUMPAD0"+(e.keyCode-0x60)+"-IMG");
		console.log("numpad",elm);
		numpad(elm);
	}
	if(e.keyCode>=0x30 && e.keyCode<=0x39){
		//数字キーの処理
		var elm=document.getElementById("NUMPAD0"+(e.keyCode-0x30)+"-IMG");
		//console.log("numpad",elm);
		numpad(elm);
	}
	if(e.keyCode==0x0D){
		//改行
		var elm=document.getElementById("NUMPAD13-IMG");
		numpad(elm);
	}
	if(e.keyCode==0xbe || e.keyCode==0x6e){
		//ピリオド
		var elm=document.getElementById("NUMPAD10-IMG");
		numpad(elm);
	}
	return true;
}

function isA(key){
	if(key==0x1B)return true;
	return false;
}
function isB(key){
	if(key==0x70)return true;
	return false;
}
function isC(key){
	if(key==0x71)return true;
	return false;
}
function isD(key){
	if(key==0x72)return true;
	return false;
}
function isRight(key){
	if(key==0x27)return true;
	if(key==0x73)return true;
	if(key==0x7D)return true;
	return false;
}
function isLeft(key){
	if(key==0x25)return true;
	if(key==0x08)return true;
	return false;
}
function isDot(key){
	if(key==0xBE)return true;
	if(key==0x6E)return true;
	return false;
}

function showModal(a,msg)
{
	if(a){
		console.log("ダイアログ",msg);
		document.getElementById("blank").innerHTML="<div style=\"width: 100%; margin: 340px auto; text-align: center; padding: 130px 0; color: #FFF; background: #08c;font-size:70px;font-weight:900;;\">"+msg+"</div></div>";
		document.getElementById("blank").style.display="block";
		//webview.focus();
	}else{
		console.log("ダイアログ","close");
		document.getElementById("blank").style.display="none";
	}
}

function window_resize()
{
	try{
		var tenkey_width=300;
		console.log("window_resize");
		lamp_start.src="./img/lamp_start.png";
		lamp_urikiri.src="./img/lamp_urikiri.png";
		lamp_nagare.src="./img/lamp_nagare.png";
		lamp_kettei.src="./img/lamp_kettei.png";
		lamp_gaibu.src="./img/lamp_gaibu.png";
		lamp_teisei.src="./img/lamp_teisei.png";

		main=document.getElementById("main");
		main_canvas=document.getElementById("main_canvas");
		main_canvas.width=main.clientWidth;
		main_canvas.height=main.clientHeight;
		main_context=main_canvas.getContext("2d");
		main_context.width=main.clientWidth;
		main_context.height=main.clientHeight;

		var sub=document.getElementById("sub");
		main_canvas2=document.getElementById("main_canvas2");
		main_canvas2.width=sub.clientWidth;
		main_canvas2.height=sub.clientHeight;
		main_context2=main_canvas.getContext("2d");
		main_context2.width=sub.clientWidth;
		main_context2.height=sub.clientHeight;

		console.log("main        ="+main.clientWidth+" x "+main.clientHeight);
		console.log("main_canvas ="+main_canvas.width+" x "+main_canvas.height);
		console.log("main_context="+main_context.width+" x "+main_context.height);

		//出品番号描画位置
		posSPNO.top=14;
		posSPNO.left=10;
		posSPNO.width=475;
		posSPNO.height=90;

		//行灯描画位置
		posANDON.top=414;
		posANDON.left=137;
		posANDON.width=107;
		posANDON.height=88;
		posANDON.w=120;

		//価格描画位置
		posPRICE.top=514;
		posPRICE.left=10;
		posPRICE.width=475;
		posPRICE.height=90;

		//画像描画位置
		posIMAGE.top=0;
		posIMAGE.left=500;
		posIMAGE.width=920;
		posIMAGE.height=1080;

		//売り切り描画位置
		posURIKIRI.top=214;
		posURIKIRI.left=10;
		posURIKIRI.width=475;
		posURIKIRI.height=90;

		//決定描画位置
		posKETTEI.top=314;
		posKETTEI.left=10;
		posKETTEI.width=475;
		posKETTEI.height=90;

		//スタート描画位置
		posSTART.top=314;
		posSTART.left=10;
		posSTART.width=475;
		posSTART.height=90;

		//流れ描画位置
		posNAGARE.top=214;
		posNAGARE.left=10;
		posNAGARE.width=475;
		posNAGARE.height=90;

		//訂正描画位置
		posTEISEI.top=114;
		posTEISEI.left=10;
		posTEISEI.width=475;
		posTEISEI.height=90;

		return;

		//単位表示
		main_context.font = "28px 'ＭＳ Ｐゴシック'";
		main_context.fillStyle="white";
		main_context.textBaseline="bottom";
		var h=Math.floor(defVect[defPrice].w*0.3);
		for(var i=0;i<2;i++){
			var tmpLeft=defVect[defPrice].left;
			var tmpWidth=defVect[defMain].width;
			var tmpHeight=defVect[defMain].height;
			main_context.fillText("価",tmpLeft+tmpWidth*i-h,tmpHeight-h,defVect[defPrice].w*0.3);
			main_context.fillText("格",tmpLeft+tmpWidth*i-h,tmpHeight,defVect[defPrice].w*0.3);
			main_context.fillText("千",tmpLeft+tmpWidth*i+(5*defVect[defPrice].w)+defVect[defPrice].w*0.7,tmpHeight-h,defVect[defPrice].w*0.3);
			main_context.fillText("円",tmpLeft+tmpWidth*i+(5*defVect[defPrice].w)+defVect[defPrice].w*0.7,tmpHeight,defVect[defPrice].w*0.3);
		}
	}catch(e){
		console.log("window_resize",e);
	}
}

//function drawLane(){
//	if(cur_lane==LANE_NONE)return;
//	for(var i=0;i<2;i++){
//		var lane=(cur_lane-1)*2+i;
//		//console.log("drawLane",lane);
//		drawImage(font_lane[lane],posLANE.left,posLANE.top,posLANE.width,posLANE.height);
//	}
//}


function drawStartLamp(lane,flg){
	if(flg!=0){
		drawImage(lamp_start,posSTART.left,posSTART.top,posSTART.width,posSTART.height);
		console.log("LAMP",lane+" start on");
	}else{
		console.log("LAMP",lane+" start off");
		col='rgb(10,10,10)';
		fillRect(col,posSTART.left,posSTART.top,posSTART.width,posSTART.height);
	}
}

function drawKetteiLamp(lane,flg,flg2){
	var buff="購買店 "+lane_stat_new[lane].rakuten+"様";
	if(flg2==1 && GAIBU_FLG){
		drawImage(lamp_gaibu,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);

		if(RAKUTEN_FLG){
			main_context.font = "28px 'ＭＳ Ｐゴシック'";
			main_context.fillStyle="white";
			main_context.textBaseline="top";
			main_context.fillText(buff,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);
		}
	}else if(flg!=0){
		drawImage(lamp_kettei,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);
		if(RAKUTEN_FLG){
			main_context.font = "28px 'ＭＳ Ｐゴシック'";
			main_context.fillStyle="white";
			main_context.textBaseline="top";
			main_context.fillText(buff,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);
		}
	}else{
		if(RAKUTEN_FLG){
			col='rgb(0,0,0)';
			fillRect(col,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);
		}

		col='rgb(10,10,10)';
		fillRect(col,posKETTEI.left,posKETTEI.top,posKETTEI.width,posKETTEI.height);
	}
}

function drawNagareLamp(lane,flg){
	if(flg!=0){
		drawImage(lamp_nagare,posNAGARE.left,posNAGARE.top,posNAGARE.width,posNAGARE.height);
	}else{
		col='rgb(10,10,10)';
		fillRect(col,posNAGARE.left,posNAGARE.top,posNAGARE.width,posNAGARE.height);
	}
}

function drawUrikiriLamp(lane,flg){
	if(flg!=0){
		drawImage(lamp_urikiri,posURIKIRI.left,posURIKIRI.top,posURIKIRI.width,posURIKIRI.height);
	}else{
		col='rgb(10,10,10)';
		fillRect(col,posURIKIRI.left,posURIKIRI.top,posURIKIRI.width,posURIKIRI.height);
	}
}

function drawTeiseiLamp(lane,flg){
	if(flg!=0){
		console.log("リスト訂正 ON("+lane+")");
		drawImage(lamp_teisei,posTEISEI.left,posTEISEI.top,posTEISEI.width,posTEISEI.height);
	}else{
		console.log("リスト訂正 OFF("+lane+")");
		col='rgb(10,10,10)';
		fillRect(col,posTEISEI.left,posTEISEI.top,posTEISEI.width,posTEISEI.height);
	}
}

function drawTeiseiLine(lane,flg){
	if(flg!=0){
		try{
			col='#FF0000';
			main_context.strokeStyle = col;
			//main_context.globalAlpha=0.7;
			main_context.lineWidth=1;
			for(var i=0;i<8;i++){
				main_context.strokeRect(lane*defVect[defMain].width+i,defVect[defMain].top+i,defVect[defImage].width-i*2-1,defVect[defImage].height-i*2-1);
			}
			//main_context.globalAlpha=1;
			console.log("■■■■■■TEISEI LINE");
		}catch(e){
			console.log("drawTeiseiLine",e);
		}
	}
	if(cur_lane>=LANE_AB && cur_lane<=LANE_EF){
		try{
			var _cols=new Array();
			_cols[0]="BLACK";
//			_cols[1]="rgb(0xF6,0x81,0x80)";	//#f68180
//			_cols[2]="rgb(0xFF,0xAB,0x00)";
//			_cols[3]="rgb(0x3D,0xA4,0xFF)";
			_cols[1]="#F68180";	//#f68180
			_cols[2]="#FFAB00";
			_cols[3]="#3DA4FF";
			main_context.beginPath();
			main_context.strokeStyle=_cols[cur_lane];
			main_context.fillStyle=_cols[cur_lane];
			main_context.lineWidth=2;
			main_context.moveTo(defVect[defMain].width,0);
			main_context.lineTo(defVect[defMain].width,defVect[defMain].height);
			main_context.stroke();
		}catch(e){
			console.log("drawTeiseiLine2",e);
		}
	}
}
function loadLargeFont(){
	for(var i=0;i<10;i++){
		font_l[i]=new Image();
		font_l[i].onload=onImageLoad;
		font_l[i].src="./img/num"+i+".png";
	}
	s="ABCDEF";
	for(var i=0;i<6;i++){
		font_lane[i]=new Image();
		font_lane[i].src="./img/"+s.substring(i,i+1)+".png";
	}
}
function onImageLoad()
{
	//console.log("Image loaded");
}

function drawImage(img,x,y,w,h)
{
	try{
		main_context=main_canvas.getContext("2d");
		main_context.drawImage(img,x,y,w,h);
		main_context2=main_canvas2.getContext("2d");
		main_context2.drawImage(img,x,y,w,h);
	}catch(e){
		console.log("drawImage",e);
		console.log("parameter="+x+" "+y+" "+w+" "+h);
	}
}

function fillRect(col,x,y,w,h)
{
	main_context.fillStyle=col;
	main_context.fillRect(x,y,w,h);

	main_context2.fillStyle=col;
	main_context2.fillRect(x,y,w,h);
}

function drawSpno(lane){
	var l=lane%2;
	try{
		if(lane_stat[l].spno==lane_stat_new[lane].spno)return;
		//console.log("drawSpno l="+l);

		var spno=lane_stat_new[lane].spno;
		var str_spno;
		if(SPNO_FILL==FILL_ZERO){
			str_spno=("00000"+spno).substr(-1*SPNO_LENGTH);
		}else{
			str_spno=("     "+spno).substr(-1*SPNO_LENGTH);
		}
		console.log("SPNO CHG lane="+lane+" SPNO="+str_spno);
		main_context.font = "72px 'ＭＳ ゴシック'";
		var w=main_context.measureText(str_spno).width;
		main_context.fillStyle="black";
		main_context.fillRect(posSPNO.left,posSPNO.top,w,posSPNO.height);
		main_context.textBaseline="top";
		main_context.fillStyle="white";
		main_context.fillText(str_spno,posSPNO.left,posSPNO.top);

		main_context2.fillStyle="black";
		main_context2.fillRect(posSPNO.left,posSPNO.top,w,posSPNO.height);
		main_context2.textBaseline="top";
		main_context2.fillStyle="white";
		main_context2.fillText(str_spno,posSPNO.left,posSPNO.top);
		lane_stat[l].spno=lane_stat_new[lane].spno;
		drawTeiseiLine(l,lane_stat_new[lane].lamp_teisei);
		ImageDraw(lane,lane_stat[l].spno);
	}catch(e){
		console.log("drawSpno",e);
	}
}

function paddingleft(val,char,n){
	var leftval="";
	for(;leftval.length<n;leftval+=char);
	return(leftval+val).slice(-n);
}

function drawPrice(lane)
{
	try{
		var max_len=6;
		var l=lane%2;
		if(lane_stat[l].price==lane_stat_new[lane].price)return;
		var str_price=paddingleft(lane_stat_new[lane].price.toString()," ",max_len);
		//console.log("drawPrice start "+lane_stat_new[lane].price+" "+str_price);
		for(var j=0;j<max_len;j++){
			if(j!=max_len-1){
				if(str_price.substr(j,1)==" "){
					fillRect("black",posPRICE.left+(l*(posPRICE.width/6)),posPRICE.top,(l*(posPRICE.width/6)),posPRICE.height);
				}else{
					var k=str_price.substr(j,1)*1;
					drawImage(font_l[k]
						,posPRICE.left+(l*(posPRICE.width/6))
						,posPRICE.top
						,(l*(posPRICE.width/6))
						,posPRICE.height);
				}
			}else{
				if(str_price.substr(j,1)==" "){
					fillRectt("black",posPRICE.left+(l*(posPRICE.width/6)),posPRICE.top,(l*(posPRICE.width/6)),posPRICE.height);
				}else{
					var k=str_price.substr(j,1)*1;
					drawImage(font_l[k]
						,posPRICE.left+(l*(posPRICE.width/6))
						,posPRICE.top
						,(l*(posPRICE.width/6))*0.7
						,posPRICE.height*0.7);
					//console.log("drawPrice = "+k+" x="+(j*68));
				}
			}
		}
		lane_stat[l].price=lane_stat_new[lane].price;
	}catch(e){
		console.log("drawPrice",e);
	}
}

function drawAndon(lane)
{
	var col;
	var cols=new Array();
	var l=lane%2;
	cols[0]="red";
	cols[1]="yellow";
	cols[2]="green";
var s="";
	try{
		if(lane_stat[l].andon==lane_stat_new[lane].andon)return;
		var bit=1;
		for(var i=0;i<3;i++){
			var j=2-i;
			if((lane_stat_new[lane].andon&bit)!=0){
				col=cols[i];
				s+="o";
			}else{
				s+="x";
				col='rgb(10,10,10)';
			}
			fillRect(col,posANDON.left+(posANDON.w*(2-i)),posANDON.top,posANDON.width,posANDON.height);
			bit<<=1;
		}
		//console.log("andon",lane_stat_new[lane].andon.toString(2)+" "+s);
		lane_stat[l].andon=lane_stat_new[lane].andon;
	}catch(e){
		console.log("drawAndon",e);
	}
}

function drawLamp(lane)
{
	var l=lane%2;
	try{
		if(lane_stat[l].lamp_start!=lane_stat_new[lane].lamp_start){
			drawStartLamp(l,lane_stat_new[lane].lamp_start);
			lane_stat[l].lamp_start=lane_stat_new[lane].lamp_start;
		}
		if(lane_stat[l].lamp_urikiri!=lane_stat_new[lane].lamp_urikiri){
			drawUrikiriLamp(l,lane_stat_new[lane].lamp_urikiri);
			lane_stat[l].lamp_urikiri=lane_stat_new[lane].lamp_urikiri;
		}
		if(lane_stat[l].lamp_nagare!=lane_stat_new[lane].lamp_nagare){
			if(lane_stat[l].lamp_urikiri==0)drawNagareLamp(l,lane_stat_new[lane].lamp_nagare);
			lane_stat[l].lamp_nagare=lane_stat_new[lane].lamp_nagare;
		}
		if(lane_stat[l].lamp_kettei!=lane_stat_new[lane].lamp_kettei){
			if(lane_stat[l].lamp_start==0)drawKetteiLamp(l,lane_stat_new[lane].lamp_kettei,lane_stat_new[lane].lamp_gaibu);
			lane_stat[l].lamp_kettei=lane_stat_new[lane].lamp_kettei;
		}
		if(lane_stat[l].lamp_teisei!=lane_stat_new[lane].lamp_teisei){
			drawTeiseiLamp(l,lane_stat_new[lane].lamp_teisei);
			lane_stat[l].lamp_teisei=lane_stat_new[lane].lamp_teisei;
		}
	}catch(e){
		console.log("drawLamp",e);
	}
}

function onSendComplete(info){
	console.log("onSendComplete",info);
}
function onReceive(info) {
	console.log("onReceive");
}

function onReceiveUDP(info) {
	console.log("onReceiveUDP");
	if (info.socketId == sock_price){
		recvPrice(info);
	}else{
		console.log("unknown socket :"+info);
		var ab=new ArrayBuffer(info.data);
		var s="";
		for(var i=0;i<info.length;i++){
			s="0x"+ab[i].toString(16)+" ";
		}
		console.log("Receive UDP",s);
		console.log("Receive UDP",ab2t(info.data));
		console.log("Receive UDP",info);
		console.log("-----------------");
	}
}

function recvPrice(info)
{
	var dv;
	var cmd;
	var lane;
	var l;
	try{
		dv=new DataView(info.data);
		cmd=dv.getUint16(0,true);
		lane=dv.getUint16(16,true)-1;
		l=((lane-(lane%2))/2+1);
	}catch(e){}
	//console.log("recvPrice cmd=0x"+cmd.toString(16),lane);
	if(cmd==0x000F){
		//出品情報
		lane_stat_new[lane].last_p1=info.data;
		getP1data(info.data);
		//console.log("■P1 lane="+lane+" SPNO="+lane_stat_new[lane].spno+" price="+lane_stat_new[lane].price+" teisei="+lane_stat_new[lane].lamp_teisei);
		if(lane==0){
			try{
				drawSpno(lane);
				drawPrice(lane);
				drawAndon(lane);
				drawLamp(lane);
			}catch(e){
				console.log("recvPrice-getP1data",e);
			}
		}
	}else if(cmd==0x001A){
		lane_stat_new[lane].last_p2=info.data;
		getP2data(info.data);
		if(lane==0){
			//console.log("■P2 lane="+lane+" SPNO="+lane_stat_new[lane].spno+" price="+lane_stat_new[lane].price);
			drawAndon(lane);
			drawSpno(lane);
			drawPrice(lane);
			drawLamp(lane);
		}
	}else if(cmd==0x4321){
		//再起動
		console.log("shutdown CMD RECEIVED");
		window.close();
	}else{
		console.log("unknown UDP cmd","0x"+cmd.toString(16));
	}
}

function recvImage(info)
{
	console.log("recvImage:"+ab2t(info.data));
}


function sendResult(info){
	console.log("sendResult="+info.resultCode);
}

function onCallback( result ){
    console.log( "onCallback" );
}

function errorSocket(info){
	console.log("errorSocket",info);
	if(info.socketId==sock_price){
		console.log("PRICE",info_price);
	}
	if(debug_flg){
		init_flg=1;
		return;
	}
}

function completeSocket(info){
	console.log("completeSocket",info);
}

function writeDebug(msg){
	console.log(msg);
	document.getElementById("debug_win").style.display="none";
	//document.getElementById("debug_win").innerHTML=msg+"<BR>"+document.getElementById("debug_win").innerHTML;
}
function ab2str(buf) {
	//console.log("ab2str="+str2ab(String.fromCharCode.apply(null, new Uint16Array(buf))));
	return String.fromCharCode.apply(null, new Uint16Array(buf));
}

function str2ab(str) {
	var buf = new ArrayBuffer(str.length*2); // 2 bytes for each char
	var bufView = new Uint16Array(buf);
	for (var i=0, strLen=str.length; i<strLen; i++) {
		bufView[i] = str.charCodeAt(i);
	}
	console.log("str2ab="+ab2str(buf));
	return buf;
}
function t2ab(str /* String */)
{
	var buffer = new ArrayBuffer(str.length);
	var view = new DataView(buffer);
	for(var i = 0, l = str.length; i < l; i++) {
		view.setInt8(i, str.charAt(i).charCodeAt());
	}
	console.log("t2ab="+ab2t(buffer));
	return buffer;
}

function ab2t(buffer /* ArrayBuffer */) {
	var arr = new Int8Array(buffer);
	var str = "";
	for(var i = 0, l = arr.length; i < l; i++) {
		str += String.fromCharCode.call(this, arr[i]);
	}
//	console.log("ab2t="+str);
	return str;
}

function getP1data(buffer){
	try{
		if(lastTimer+TimerTimeout<(new Date()).getTime()){
			console.log("■■■■■■ タイマー停止検出 再始動■■■■■■");
			ImageTimer();
		}
		var dv=new DataView(buffer);

		var cmd=dv.getUint16(0,true);
		var cmd2=dv.getUint16(2,true);
		var lane=dv.getUint16(16,true)-1;
		var teisei=dv.getUint8(20,true);

		var sp1=dv.getInt32(36,true);
		var start_price1=dv.getInt32(40,true);
		var sp2=dv.getInt32(44,true);
		var start_price2=dv.getInt32(48,true);
		var sp3=dv.getInt32(52,true);
		var sp4=dv.getInt32(56,true);

		if(sp1<0)sp1=0;
		if(sp2<0)sp2=0;
		if(sp3<0)sp3=0;
		if(sp4<0)sp4=0;
		lane_stat_new[lane].spno=sp1;
		if(start_price1<0)start_price1=0;
		lane_stat_new[lane].price=start_price1;
		lane_stat_new[lane].lamp_teisei=teisei;

		setSpno(lane,sp1,sp2,sp3,sp4,0);
	}catch(e){
		console.log("getP1data",e);
	}
}

var l1,l2,l3,l4,l5,l6,l7,l8;
function getP2data(buffer){
	try{
		var dv=new DataView(buffer);
//var s="";
//for(var i=0;i<4;i++){
//	s+="0x"+dv.getUint8(i+24).toString(16)+" ";
//}
//console.log("P2",s);
		var cmd=dv.getUint16(0,true);
		var cmd2=dv.getUint16(2,true);
		var lane=dv.getUint16(16,true)-1;

		var sp1=dv.getInt32(20,true);
		var price=dv.getInt32(24,true);
		var raku_seat=dv.getUint32(76,true);

		var lamp1=dv.getUint8(32,true);
		var lamp2=dv.getUint8(33,true);
		var lamp3=dv.getUint8(34,true);
		var lamp4=dv.getUint8(35,true);
		var lamp5=dv.getUint8(36,true);
		var lamp6=dv.getUint8(37,true);
		var lamp7=dv.getUint8(38,true);
		var lamp8=dv.getUint8(39,true);
//console.log("lamp",lamp1.toString(16)+" "+lamp2.toString(16)+" "+lamp3.toString(16));

		//var teisei=dv.getUint8(20,true);

		if(sp1<0)sp1=0;
		lane_stat_new[lane].spno=sp1;
		if(price<0)price=0;
		lane_stat_new[lane].price=price;
		//lane_stat_new[lane].lamp_teisei=teisei;

		if((lamp2&0x01)!=0){
			rakuten="";
			var a;
			for(var i=0;i<5;i++){
				a=dv.getUint8(67+i)-0x30;
				rakuten+=""+a;
			}
			lane_stat_new[lane].rakuten=rakuten;
			lane_stat_new[lane].raku_seat=raku_seat;
			console.log("落札店",rakuten+"@"+raku_seat);
		}else{
			lane_stat_new[lane].rakuten="";
		}

		lane_stat_new[lane].lamp_start=(lamp1&0x80)==0?0:1;
		lane_stat_new[lane].lamp_urikiri=(lamp2&0x80)==0?0:1;
		lane_stat_new[lane].lamp_nagare=(lamp2&0x02)==0?0:1;
		lane_stat_new[lane].lamp_kettei=(lamp2&0x01)==0?0:1;
		lane_stat_new[lane].andon=lamp3;
		if((lamp2&0x01)!=0){
			if(raku_seat>=9901 && raku_seat<=9999){
				lane_stat_new[lane].lamp_gaibu=1;
			}else{
				lane_stat_new[lane].lamp_gaibu=0;
			}
		}else{
			lane_stat_new[lane].lamp_gaibu=0;
		}
//console.log("lamp",lane_stat_new[lane].lamp_start+""+lane_stat_new[lane].lamp_urikiri+""+lane_stat_new[lane].lamp_nagare+""+lane_stat_new[lane].lamp_kettei+""+lane_stat_new[lane].lamp_gaibu);

		var lane_pos=(lane-1-((lane-1)%2))/2+1;
		//出品番号変化あり
//		if(cur_lane==lane_pos){
//			if(lane_stat[lane].spno!=lane_stat_new[lane].spno){
//				clearImage(lane_pos);
//			}
//		}
		setSpno2(lane,sp1);
	}catch(e){
		console.log("getP2data",e);
	}
}

function stringToArrayBuffer(string) {
	var buffer = new ArrayBuffer(string.length);
	var bufView = new Uint8Array(buffer);
	for (var i=0; i < string.length; i++) {
		bufView[i] = string.charCodeAt(i);
	}
	return buffer;
}

function arrayBufferToString(buffer) {
	return String.fromCharCode.apply(null, new Uint8Array(buffer));
}

function openPrice(){
	writeDebug("connectPrice2()");
	if(sock_price!=-1){
		chrome.sockets.udp.close(sock_price);
		sock_price=-1;
	}

	chrome.sockets.udp.create({}, function (socketInfo) {
		sock_price = socketInfo.socketId;
		chrome.sockets.udp.bind( sock_price, "0.0.0.0", 10020, function (result) {
			if(result < 0) {
				console.log(chrome.runtime.lastError.message);
			} else {
				chrome.sockets.udp.getInfo( sock_price, function(result){
					console.log(result);
				});
				writeDebug("UDP socket Open complete");
				showModal(false,"");
				chrome.sockets.udp.send( sock_price, t2ab("TEST"), "10.10.100.165", 10025, function (sendInfo) {
					if (sendInfo.resultCode < 0) {
						console.log(chrome.runtime.lastError.message);
					}
				});
			}
		});
	});
}

var last_height;
var load_img1_cnt=0;
var load_img2_cnt=0;
var load_img1=new Array();
var load_img2=new Array();

for(i=0;i<3;i++){
	load_img1[i]=null;
	load_img2[i]=null;
}

function clearImage(lane){
	console.log("clearImage "+lane);
	drawImage(noimage,(lane%2)*defVect[defMain].width,0,defVect[defImage].width,defVect[defImage].height);
	try{
		var _cols=new Array();
		_cols[0]="BLACK";
		_cols[1]="#F68180";	//#f68180
		_cols[2]="#FFAB00";
		_cols[3]="#3DA4FF";
		main_context.beginPath();
		main_context.strokeStyle=_cols[cur_lane];
		main_context.fillStyle=_cols[cur_lane];
		main_context.lineWidth=2;
		main_context.moveTo(defVect[defMain].width,0);
		main_context.lineTo(defVect[defMain].width,defVect[defMain].height);
		main_context.stroke();
		var l=(cur_lane-1)*2+(lane%2);
		drawTeiseiLine(lane%2,lane_stat_new[l].lamp_teisei);
	}catch(e){
		console.log("drawTeiseiLine2",e);
	}
	return;
//	if(lane==0){
//		col='rgb(0,0,0)';
//		main_context.fillStyle = col;
//		main_context.fillRect(0,0,defVect[defImage].width,defVect[defImage].height);
//	}else{
//		col='rgb(0,0,0)';
//		main_context.fillStyle = col;
//		main_context.fillRect(defVect[defMain].width,0,defVect[defImage].width,defVect[defImage].height);
//	}
}

function loadImage(lane,spno){
	if(lane==0){
		load_img1_cnt=0;
		loadImageRequest1(spno);
	}else if(lane==1){
		load_img2_cnt=0;
		loadImageRequest2(spno);
	}else{
		console.log("loadImage lane error",lane);
	}
}

//////// メニュー部

var menuid=1;
var curNum=0;
var curNumX=0;

function menu_init(){
	preload(["img/NUM0W.png","img/NUM1W.png","img/NUM2W.png","img/NUM3W.png","img/NUM4W.png","img/NUM5W.png","img/NUM6W.png","img/NUM7W.png","img/NUM8W.png","img/NUM9W.png","img/NUM-W.png"]);
	showNumber(10);

	for(var i=0;i<=15;i++){
		var elm=document.getElementById("NUMPAD"+zeroPadding(i,2)+"-IMG");
		if(elm==null)continue;
		//elm.onclick=function(){ numpad(i); };
		elm.onclick=numpad;
	}
}

function zeroPadding(number, length){
    return (Array(length).join('0') + number).slice(-length);
}

function showTenkey(flg){
	var subMenu1 = document.getElementById( 'SUB-MENU01' );
	var subMenu2 = document.getElementById( 'SUB-MENU02' );
	if( subMenu1 && subMenu2 ){
		if( flg ){
			subMenu1.style.display='none';
			subMenu2.style.display='';
			curNum=1;
			showNumber(10);
			input_str="";
		}else{
			subMenu1.style.display='';
			subMenu2.style.display='none';
		}
	}
}

function clearBuyer()
{
	lane_stat[0].spno=-2;
	lane_stat[1].spno=-2;
	drawSpno(0);
	drawPrice(0,true);
	drawAndon(0,true);
	drawLamp(0,true);
}

function preload(imgs){
	for(var i = 0; i < imgs.length; i++){
		var imgObj = new Image();
		imgObj.src = imgs[i];
	}
}

function numpad(elm){
	var id;
	try{
		id=this.id.substring(6,8);
	}catch(e){
		id=elm.id.substring(6,8);
	}
	num=id*1;
	var ret;

	var d = new Date();
	var ms = d.getTime();


	if( num==13 ){
		if(seatchg!=0){
			showModal(true,"保存処理中");
			SaveConfig(curNum);
			seatchg=0;
			SeatInput(seatchg);
			curNum=0;
			showNumber(10);
			return;
		}
		if(input_str==CMD_SHUTDOWN){
			try{
				showModal(true,"終了中");
				if(sock_price!=-1){
					sendPriceStopRequest();
					chrome.sockets.udp.close(sock_price);
				}
			}catch(e){
			}
			window.close();
			return;
		}else if(input_str==CMD_SEATCHG){
			showConfig(true);
			return;
			seatchg=1;
			SeatInput(seatchg);
			console.log("シート入力状態");
			showNumber(10);
			return;
		}
		input_str="";

		var posno=1;
		var addr=URL_SHITAMI[1];
		addr=addr.replace("##SPNO##",curNum);
		addr=addr.replace("##RANDOM##",ms);
		document.getElementById("shitami").innerHTML="<webview id=\"webview\" style=\"position: absolute; top:0px; left:0px; width:100%; height:100%;background-color:#000;\" src=\""+addr+"\"></webview>";
		webview=document.getElementById("webview");
		document.getElementById("shitami").style.display="block";
		webview.focus();
		curNumX=1;
	}else{
		ret = showNumber(num);
	}
}

function showNumber( num ){

	var errAction=0;
	//console.log( curNum + "," + num );
	if( curNum==0 ){
		if( num<=9 ){
			curNum=num;
			input_str+=num+"";
		}else if( num==14 ){
			curNum+=1;
		}else if( num==15 ){
			errAction=1;
			curNum=0;
		}else if( num==10 ){
			if(curNum==0){
				showMain();
			}
			errAction=1;
			curNum=0;
			input_str="";
		}
		curNumX=0;
	}else{
		var preNum;
		if( num<=9 ){
			input_str+=num+"";
			if( curNumX==1 ){
				curNumX=0;
				preNum=num;
				curNum=preNum;
			}else{
				preNum=(curNum*10)+num;
				if( preNum<=99999 ){
					curNum=preNum;
				}else{
					errAction=1;
				}
			}
		}else if( num==14 ){
			preNum=curNum+1;
			curNumX=0;
			if( preNum<99999 ){
				curNum=preNum;
			}else{
				errAction=1;
			}
		}else if( num==15 ){
			preNum=curNum-1;
			curNumX=0;
			if( preNum>0 ){
				curNum=preNum;
			}else{
				errAction=1;
			}
		}else if( num==10 ){
			errAction=1;
			curNum=0;
		}
	}
	
	var zero=0;
	var dispNum = zeroPadding( curNum, 5 );
	for( i=0;i<5;i++ ){
		var dig = dispNum.charAt(i);
		if( dig > 0 || i==4 ) zero = 1;
		var srcImage;
		if( dig == 0 ){
			if( zero ){
				srcImage = "img/NUM"+dig+"W.png";
			}else{
				srcImage = "img/NUM-W.png";
			}
		}else{
			srcImage = "img/NUM"+dig+"W.png";
		}
		var numObj = document.getElementById("u"+i.toString());
		if( numObj ) numObj.src=srcImage;
	}
	return errAction;
}

//////// メニュー部終了

function showMain(){
	if(pos_number=="" || pos_number=="00000000"){
		showEmpty();
	}else{
		showBlank();
	}
}

function SaveConfig(num)
{
	console.log("Save 座席番号",num);
//	chrome.storage.local.set({seat_no:num,AB:AB_DISABLE,CD:CD_DISABLE,EF:EF_DISABLE},function(){
	chrome.storage.local.set({seat_no:num,GAIBU_FLG:GAIBU_FLG,RAKUTEN_FLG:RAKUTEN_FLG},function(){
		console.log("SaveConfig Complete");
		LoadConfig(null);
	});
}

function LoadConfig(func){
	if(func!=null)LoadCallback=func;
	chrome.storage.local.get({seat_no:0,AB:false,CD:false,EF:false,GAIBU_FLG:true,RAKUTEN_FLG:true},function(_items){
		seat_no=_items.seat_no;
//		AB_DISABLE=_items.AB;
//		CD_DISABLE=_items.CD;
//		EF_DISABLE=_items.EF;
		GAIBU_FLG=_items.GAIBU_FLG;
		RAKUTEN_FLG=_items.RAKUTEN_FLG;
//		console.log("load AB",AB_DISABLE);
//		console.log("CD",CD_DISABLE);
//		console.log("EF",EF_DISABLE);
		console.log("座席番号",seat_no);
		console.log("外部落札表示",GAIBU_FLG);
		console.log("落札店表示",RAKUTEN_FLG);
		if(seat_no<=0){
			seatchg=1;
			SeatInput(seatchg);
		}else if(seat_no>=2400){
			WEBIP="10.10.100.160";
			PRICE_IP="10.10.100.165";
			//pos_number="000006233";
			setInitialUrl();
		}else{
			seatchg=0;
			SeatInput(seatchg);
		}
		if(LoadCallback!=null){
			LoadCallback();
			LoadCallback=null;
		}
		changeLaneButton();
	});
}

function setSpno(lane,sp1,sp2,sp3,sp4,sp5){
	//console.log("setSpno",sp1+","+sp2+","+sp3+","+sp4+","+sp5);
	var sp=new Array();
	sp[0]=sp1;
	sp[1]=sp2;
	sp[2]=sp3;
	sp[3]=sp4;
	sp[4]=sp5;
	var empty=new Array();
	empty[0]=1;
	empty[1]=1;
	empty[2]=1;
	empty[3]=1;
	empty[4]=1;
	for(var i=0;i<imgArray[lane].length;i++){
		for(var j=0;j<RING_MAX;j++){
			if(sp[j]==0)continue;
			if(imgArray[lane][i].spno==sp[j]){
				sp[j]=0;
				empty[i]=0;
				break;
			}
		}
	}
	for(var i=0;i<imgArray[lane].length;i++){
		if(empty[i]==1){
			for(var j=0;j<RING_MAX;j++){
				if(sp[j]<=0)continue;
				//console.log("setSpno","lane="+lane+" SP="+sp[j]+" POS="+i);
				imgArray[lane][i].spno=sp[j];
				imgArray[lane][i].mode=MODE_NONE;
				imgArray[lane][i].img=null;
				sp[j]=0;
				empty[i]=0;
				break;
			}
		}
	}
}
function setSpno2(lane,sp1){
	if(imgArray[lane][RING_MAX-1].spno==sp1)return;
	for(var i=0;i<RING_MAX-1;i++){
		if(imgArray[lane][i].spno==sp1)return;
	}
	//console.log("setSpno2","lane="+lane+" SP="+sp1);
	imgArray[lane][RING_MAX-1].spno=sp1;
	imgArray[lane][RING_MAX-1].mode=MODE_NONE;
	imgArray[lane][RING_MAX-1].img=null;
}

var ImageTimerResult;
function ImageTimer()
{
	clearTimeout(ImageTimerResult);
	lastTimer=(new Date()).getTime();

	for(var i=0;i<RING_MAX;i++){
		for(var lane=0;lane<6;lane++){
			if(imgArray[lane][i].mode==MODE_NONE && imgArray[lane][i].spno>0){
				console.log("ImageTimer2","lane="+lane+" SPNO="+imgArray[lane][i].spno);
				loadImageXXRequest(lane,i);
				return;
			}
		}
	}
	//console.log("ImageTimer");
	ImageTimerResult=setTimeout(ImageTimer,1000);
}

function loadImageXX(lane,spno){
	return;
	for(var i=0;i<RING_MAX;i++){
		if(imgArray[lane][i].mode==MODE_NONE){
			loadImageXXRequest(lane,i);
			break;
		}else if(imgArray[lane][i].mode==MODE_COMPLETE && imgArray[lane][i].spno==spno){
			drawImage(imgArray[lane][i].img,(lane%2)*defVect[defMain].width,0,defVect[defImage].width,defVect[defImage].height);
		}
	}
}

function ImageDraw(lane,spno){
	for(var i=0;i<RING_MAX;i++){
		if(imgArray[lane][i].mode==MODE_COMPLETE && imgArray[lane][i].spno==spno){
			console.log("ImageDraw","LANE="+lane+" SPNO="+spno);
			if(imgArray[lane][i].img.height>1){
				drawImage(imgArray[lane][i].img,(lane%2)*defVect[defMain].width,0,defVect[defImage].width,defVect[defImage].height);
			}else{
				drawImage(noimage,(lane%2)*defVect[defMain].width,0,defVect[defImage].width,defVect[defImage].height);
			}
			drawTeiseiLine(lane%2,lane_stat_new[lane].lamp_teisei);
			return;
		}
	}
	clearImage(lane%2);
}

function loadImageXXRequest(lane,i){
	//var cd=center_cd;
	var spno=imgArray[lane][i].spno;

	try{
		console.log("loadImageXXRequest : spno="+spno);
		var url=IMG_URL[0];
//		url=url.replace("##ASP##",asp_cd.toString());
//		url=url.replace("##CD1##",cd.toString());
//		url=url.replace("##CD2##",cd2.toString());
//		url=url.replace("##KAISAINO##",kaisaino.toString());
//		url=url.replace("##IMG##","2");
		url=url.replace("##SPNO##",spno);

console.log("Image Request",url);
		var nURL;
		imgArray[lane][i].mode=MODE_LOADING;
		imgArray[lane][i].loader = null;
		imgArray[lane][i].loader = new XMLHttpRequest();
		imgArray[lane][i].loader.responseType = "blob";
		imgArray[lane][i].loader.open("GET", url, true);
		imgArray[lane][i].loader.onreadystatechange = function() {
			if(this.readyState==4){
				if (this.status == 200) {
					var blob = new Blob([this.response], {type: 'image/jpg'});
					nURL = URL.createObjectURL(blob);
					imgArray[lane][i].img = null;
					imgArray[lane][i].img = new Image();
					imgArray[lane][i].img.onload=function(){
						imgArray[lane][i].mode=MODE_COMPLETE;
						var l=(lane-(lane%2))/2;
						imgcnt++;
						console.log("loadImage compelte",imgArray[lane][i].spno);
						console.log("download count",imgcnt);
						console.log("spno="+lane_stat[l].spno);
						if(lane==0 && lane_stat_new[lane].spno==imgArray[lane][i].spno){
							drawImage(imgArray[lane][i].img,posIMAGE.left,posIMAGE.top,posIMAGE.width,posIMAGE.height);
							drawTeiseiLine(lane%2,lane_stat_new[lane].lamp_teisei);
						}
						if(imgArray[lane][i].img.src!=null)URL.revokeObjectURL(imgArray[lane][i].img.src);
						ImageTimer();
					};
					imgArray[lane][i].img.src=nURL;
				}
			}
		};
		imgArray[lane][i].loader.send();
	}catch(e){
		console.log(e);
	}
}

function modalTimeout()
{
	showModal(false,"");
}

function showConfig(a)
{
	if(a){
		var optAB="",optCD="",optEF="",optGAIBU="",optRAKUTEN="";
		if(GAIBU_FLG)optGAIBU=" checked";
		if(RAKUTEN_FLG)optRAKUTEN=" checked";
		if(AB_DISABLE)optAB=" checked";
		if(CD_DISABLE)optCD=" checked";
		if(EF_DISABLE)optEF=" checked";
		var buff="";
		buff+="<div style=\"width: 600px; margin: 340px auto; padding:0; text-align:top; color:#000; background:#66F; font-size:30px; border:5px outset #88F;border-radius:10px;\">";
		buff+="<div style=\"height:40px;background: linear-gradient(#CCC, #777);color:black;border-radius:5px;\">&nbsp;設定</div>";
		buff+="<FORM ID=\"frm\" name=\"frm\"><CENTER>";
		buff+="<FONT SIZE=3>&nbsp</FONT><BR>";
		buff+="<TABLE BORDER=0><TR><TD>";
		buff+="<BUTTON id=\"btnSeat\" style=\"font-size:30px;\">座席番号変更("+seat_no+")</BUTTON><BR>";
		buff+="<FONT SIZE=3>&nbsp</FONT><BR>";
		buff+="<input type=\"checkbox\" id=\"chkGAIBU\" style=\"width:30px; height:30px;\""+optGAIBU+">外部落札表示<BR>";
		buff+="<input type=\"checkbox\" id=\"chkRAKUTEN\" style=\"width:30px; height:30px;\""+optRAKUTEN+">落札店表示<BR>";
//		buff+="<input type=\"checkbox\" id=\"chkAB\" style=\"width:30px; height:30px;\""+optAB+">ＡＢレーン無効<BR>";
//		buff+="<input type=\"checkbox\" id=\"chkCD\" style=\"width:30px; height:30px;\""+optCD+">ＣＤレーン無効<BR>";
//		buff+="<input type=\"checkbox\" id=\"chkEF\" style=\"width:30px; height:30px;\""+optEF+">ＥＦレーン無効<BR>";
//		buff+="<FONT SIZE=3>&nbsp</FONT><BR>";
		buff+="</TD></TR><TR><TH>";
		buff+="<BUTTON id=\"btnOK\" style=\"font-size:30px;\">決  定</BUTTON>&nbsp;";
		buff+="<BUTTON id=\"btnNG\" style=\"font-size:30px;\">取  消</BUTTON>";
//		buff+="<BUTTON id=\"btnNG\" style=\"font-size:30px;\">閉じる</BUTTON>";
		buff+="</TH></TR></TABLE></CENTER>";
		buff+="</FORM>";
		buff+="<FONT SIZE=3>&nbsp</FONT><BR>";
		buff+="</div>";
		document.getElementById("blank").innerHTML=buff;
		document.getElementById("blank").style.display="block";
		document.getElementById("frm").onsubmit=function(){ return false; };
		var elm;
		elm=document.getElementById("btnSeat");
		if(elm){
			elm.onclick=function(){
				seatchg=1;
				SeatInput(seatchg);
				console.log("シート入力状態");
				showNumber(10);
				document.getElementById("blank").style.display="none";
				showTenkey(true);
			};
		}
		elm=document.getElementById("btnOK");
		if(elm){
			elm.onclick=function(){
				document.getElementById("blank").style.display="none";
				GAIBU_FLG=document.getElementById("chkGAIBU").checked;
				RAKUTEN_FLG=document.getElementById("chkRAKUTEN").checked;
//				AB_DISABLE=document.getElementById("chkAB").checked;
//				CD_DISABLE=document.getElementById("chkCD").checked;
//				EF_DISABLE=document.getElementById("chkEF").checked;
//				console.log("settting AB",AB_DISABLE);
//				console.log("CD",CD_DISABLE);
//				console.log("EF",EF_DISABLE);
				changeLaneButton();
				SaveConfig(seat_no);
			};
		}
		elm=document.getElementById("btnNG");
		if(elm){
			elm.onclick=function(){
				document.getElementById("blank").style.display="none";
			};
		}
		//webview.focus();
	}else{
		document.getElementById("blank").style.display="none";
	}
}

function changeLaneButton(){
	var elm;
	elm=document.getElementById("MENU01-IMG");
	if(elm){
		if(AB_DISABLE==false){
			elm.style.backgroundImage="url('./img/OVER-AB.png');";
		}else{
			elm.style.backgroundImage="url('./img/DISABLE-AB.png');";
		}
	}
	elm=document.getElementById("MENU02-IMG");
	if(elm){
		if(CD_DISABLE==false){
			elm.style.backgroundImage="url('./img/OVER-CD.png');";
		}else{
			elm.style.backgroundImage="url('./img/DISABLE-CD.png');";
		}
	}
	elm=document.getElementById("MENU03-IMG");
	if(elm){
		if(EF_DISABLE==false){
			console.log("lane button","OK");
			elm.style.backgroundImage="url('./img/OVER-EF.png');";
		}else{
			console.log("lane button","NG");
			elm.style.backgroundImage="url('./img/DISABLE-EF.png');";
		}
	}
}
